
Type Calculator


	Function CrossVV:Float(value1:Vector2, value2:Vector2) 
		Return value1.X * value2.Y - value1.Y * value2.X
	End Function
	
	Function CrossVF:Vector2(value1:Vector2, value2:Float) 
		Return Vector2.Create(value2 * value1.Y, - value2 * value1.X) 
	End Function
	
	Function CrossVFRef:Vector2(value1:Vector2, value2:Float, result:Vector2)
		result.X = value2 * value1.Y
		result.Y = -value2 * value1.X
	End Function
	
	Function CrossFV:Vector2(value2:Float, value1:Vector2) 
		Return Vector2.Create(- value2 * value1.Y, value2 * value1.X) 
	End Function
	
	Function CrossFVRef(value2:Float, value1:Vector2, result:Vector2)
		result.X = -value2 * value1.Y
		result.Y = value2 * value1.X
	End Function
	
	Function TruncateRef(vector:Vector2, maxLength:Float, truncatedVector:Vector2)
		Local length:Float = vector.Length()
		length = Min(length, maxLength)
		If length > 0 Then
			vector.Normalize()
		End If
		Vector2.ScaleRef(vector, length, truncatedVector)
	End Function
End Type
